# Shopify Integration Configuration

## Environment Variables

Add these variables to your `.env` file:

```env
# Shopify Configuration
SHOPIFY_STORE_URL=your-store-name.myshopify.com
SHOPIFY_ACCESS_TOKEN=your_shopify_access_token
SHOPIFY_WEBHOOK_SECRET=your_webhook_secret_key
```

## Setup Instructions

### 1. Create a Private App in Shopify Admin

1. Go to your Shopify Admin panel
2. Navigate to **Apps** → **App and sales channel settings**
3. Click **Develop apps** → **Create an app**
4. Name your app (e.g., "Order Sync App")
5. Click **Configure Admin API scopes**
6. Enable the following scopes:
   - `read_orders` - To read order data
   - `read_products` - To read product information
   - `read_customers` - To read customer data

### 2. Generate Access Token

1. After configuring scopes, click **Install app**
2. Copy the **Admin API access token**
3. Add it to your `.env` file as `SHOPIFY_ACCESS_TOKEN`

### 3. Set up Webhooks

#### Option A: Through Shopify Admin (Recommended)
1. Go to **Settings** → **Notifications**
2. Scroll down to **Webhooks** section
3. Click **Create webhook**
4. Set:
   - **Event**: Order fulfillment
   - **Format**: JSON
   - **URL**: `https://yourdomain.com/api/shopify/webhook/orders/fulfilled`
   - **API version**: 2023-10 (latest stable)
5. Generate a webhook secret and add it to your `.env` file as `SHOPIFY_WEBHOOK_SECRET`

#### Option B: Through API (Advanced)
Use the Shopify Admin API to create webhooks programmatically.

### 4. Database Setup

Run the SQL file to create the shopify_orders table:

```bash
mysql -u your_username -p your_database_name < shopify_orders_table.sql
```

### 5. Install Dependencies

```bash
npm install
```

## API Endpoints

### Webhook Endpoints (Public)
- `POST /api/shopify/webhook/orders/fulfilled` - Receives order fulfillment webhooks
- `POST /api/shopify/webhook/orders/create` - Receives order creation webhooks

### Management Endpoints (Protected)
- `GET /api/shopify/orders` - Get all Shopify orders (paginated)
- `GET /api/shopify/orders/:id` - Get specific order details
- `POST /api/shopify/sync` - Manually sync orders from Shopify
- `GET /api/shopify/stats` - Get order statistics

## Testing

### Test Webhook Locally
Use ngrok to expose your local server:

```bash
ngrok http 5000
```

Then use the ngrok URL for your webhook endpoint in Shopify.

### Manual Sync
You can manually sync orders by calling:
```
POST /api/shopify/sync
Authorization: Bearer your_jwt_token
```

## Security Notes

1. **Webhook Verification**: All webhooks are verified using HMAC-SHA256
2. **Authentication**: Management endpoints require JWT authentication
3. **Environment Variables**: Keep your access tokens and secrets secure
4. **HTTPS**: Use HTTPS in production for webhook endpoints

## Troubleshooting

1. **Webhook not receiving data**: Check your webhook URL and ensure it's accessible
2. **Authentication errors**: Verify your access token and scopes
3. **Database errors**: Ensure the shopify_orders table exists and has proper permissions
